package ru.yandex.chemodan.util.http.zora;

import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.misc.io.http.apache.v4.InstrumentedCloseableHttpClient;

/**
 * @author yashunsky
 */
@Configuration
public class ZoraContextConfiguration {

    @Bean
    @Qualifier("zora")
    @OverridableValuePrefix("zora")
    public HttpClientConfigurator zoraHttpClientConfigurator() {
        return new ZoraHttpClientConfigurator();
    }

    @Bean
    @Qualifier("zoraHttpClient")
    public HttpClient zoraHttpClient(@Qualifier("zora") HttpClientConfigurator httpClientConfigurator) {
        final CloseableHttpClient httpClient = httpClientConfigurator.createBuilder().build();
        ((InstrumentedCloseableHttpClient) httpClient).setHostnameProcessor(s -> Option.of("ext"));
        return httpClient;
    }
}
