package ru.yandex.chemodan.util.http.zora;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderElement;

/**
 * see https://wiki.yandex-team.ru/Zora/UserGuide/#specialnyezagolovkivhttpzaprosekzora for default values
 *
 * @author yashunsky
 */
@AllArgsConstructor
@Getter
public class ZoraHeader implements Header {
    private final String header;
    private final String value;

    @Override
    public HeaderElement[] getElements() throws ParseException {
        return new HeaderElement[]{new BasicHeaderElement(header, value)};
    }

    @Override
    public String getName() {
        return header;
    }

    public static class ZoraBooleanHeader extends ZoraHeader {
        public ZoraBooleanHeader(String header, boolean value) {
            super(header, value ? "1" : "0");
        }
    }

    public static class Redirs extends ZoraBooleanHeader {
        public Redirs(boolean value) {
            super("X-Yandex-Redirs", value);
        }
    }

    public static class ForceGzip extends ZoraHeader {
        public ForceGzip() {
            super("Accept-Encoding", "gzip");
        }
    }

    public static class IgnorCerts extends ZoraBooleanHeader {
        public IgnorCerts(boolean value) {
            super("X-Ya-Ignore-Certs", value);
        }
    }

    public static class ReqId extends ZoraHeader {
        public ReqId(String value) {
            super("X-Ya-Req-Id", value);
        }
    }

    public static class DestUrl extends ZoraHeader {
        public DestUrl(String value) {
            super("X-Ya-Dest-Url", value);
        }
    }
}
