package ru.yandex.chemodan.util.http.zora;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.protocol.HttpContext;

/**
 * @author yashunsky
 */
public class ZoraRoutePlanner implements HttpRoutePlanner {

    private final String zoraHost;
    private final int zoraPort;

    public ZoraRoutePlanner(String zoraHost, int zoraPort) {
        this.zoraHost = zoraHost;
        this.zoraPort = zoraPort;
    }

    @Override
    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) {
        return new HttpRoute(target, null, new HttpHost(zoraHost, zoraPort), false);
    }
}
