package ru.yandex.chemodan.util.idm;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author yashunsky
 */
@ActionContainer
public class IdmActions {
    private final IdmRoutines idmRoutines;

    public IdmActions(IdmRoutines idmRoutines) {
        this.idmRoutines = idmRoutines;
    }

    @Action
    @Path(value="/info", methods = HttpMethod.GET)
    public IdmInfoResponse info() {
        return idmRoutines.getInfo();
    }


    @Action
    @Path(value="/add-role", methods = HttpMethod.POST)
    public IdmResponse addRole(
            @RequestParam("login") String login,
            @RequestParam("role") RoleSpecification role/*,
            @RequestParam("fields") Object fields    TBD   */)
    {
        return idmRoutines.addRole(login, role);
    }


    @Action
    @Path(value="/remove-role", methods = HttpMethod.POST)
    public Object removeRole(
            @RequestParam("login") String login,
            @RequestParam("role")  RoleSpecification role,
            /* @RequestParam("data") Option<Object> data, TBD */
            @RequestParam("fired") Option<Integer> fired)
    {
        return idmRoutines.removeRole(login, role, fired.isSome(1));
    }


    @Action
    @Path(value="/get-all-roles", methods = HttpMethod.GET)
    public IdmAllRolesResponse getAllRoles() {
        return idmRoutines.getAllRoles();
    }

}
