package ru.yandex.chemodan.util.idm;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
@BenderBindAllFields
@ActionResultPojo
public class IdmErrorResponse extends IdmResponse {
    public final Option<String> warning;
    public final Option<String> error;
    public final Option<String> fatal;

    private IdmErrorResponse(int code, Option<String> warning, Option<String> error, Option<String> fatal) {
        super(code);
        this.warning = warning;
        this.error = error;
        this.fatal = fatal;
    }

    public static IdmErrorResponse warning(int code, String message) {
        return new IdmErrorResponse(code, Option.of(message), Option.empty(), Option.empty());
    }

    public static IdmErrorResponse error(int code, String message) {
        return new IdmErrorResponse(code, Option.empty(), Option.of(message), Option.empty());
    }

    public static IdmErrorResponse fatal(int code, String message) {
        return new IdmErrorResponse(code, Option.empty(), Option.empty(), Option.of(message));
    }

    public static IdmErrorResponse standard(IdmError error) {
        switch (error.level) {
            case WARNING:
                return warning(error.code, error.message);
            case ERROR:
                return error(error.code, error.message);
            case FATAL:
                return fatal(error.code, error.message);
            default:
                throw new IllegalStateException();
        }
    }
}
