package ru.yandex.chemodan.util.idm;


import ru.yandex.commune.json.bender.JsonValueMarshaller;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.simpleType.StringValueMarshaller;

/**
 * @author yashunsky
 */
public class IdmUtils {
    public final static Language DEFAULT_LANGUAGE = Language.ENGLISH;

    public static final BenderConfiguration configuration = new BenderConfiguration(
            new BenderSettings(MembersToBind.WITH_ANNOTATIONS),
            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                    .add(Language.class, new LanguageMarshaller())
                    .add(RoleSpecification.class, new RoleSpecificationMarshaller())
                    .add(MultilingualString.class, new MultilingualStringMarshaller())
                    .build());

    public static final BenderMapper mapper = new BenderMapper(configuration);

    private static class LanguageMarshaller extends StringValueMarshaller {
        protected String toStringValue(Object o) {
            return ((Language) o).value();
        }
    }

    private static class RoleSpecificationMarshaller extends JsonValueMarshaller {
        @Override
        public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
            if (fieldValue instanceof RoleSpecification) {
                ((RoleSpecification) fieldValue).writeToJson(writer);
            }
        }
    }

    private static class MultilingualStringMarshaller extends JsonValueMarshaller {
        @Override
        public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
            if (fieldValue instanceof MultilingualString) {
                ((MultilingualString) fieldValue).writeToJson(writer);
            }
        }
    }
}
