package ru.yandex.chemodan.util.idm;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;

/**
 * @author yashunsky
 */
public class MultilingualString {
    private final Either<String, Tuple2List<Language, String>> values;

    private MultilingualString(Either<String, Tuple2List<Language, String>> values) {
        this.values = values;
    }

    public static MultilingualString singleValue(String value) {
        return new MultilingualString(Either.left(value));
    }

    public static MultilingualString withTranslations(Tuple2List<Language, String> values) {
        return new MultilingualString(Either.right(values));
    }

    public static MultilingualString bilingual(String enValue, String ruValue) {
        return MultilingualString.withTranslations(
                Tuple2List.fromPairs(Language.ENGLISH, enValue, Language.RUSSIAN, ruValue));
    }

    public boolean hasTranslations() {
        return values.isRight();
    }

    public String getSingleValue() {
        return values.getLeft();
    }

    public Tuple2List<Language, String> getTranslations() {
        return values.getRight();
    }

    public void writeToJson(BenderJsonWriter writer) {
        if (values.isLeft()) {
            writer.writeString(values.getLeft());
        } else {
            writer.writeObjectStart();
            values.getRight().forEach((language, value) -> {
                writer.writeFieldName(language.value());
                writer.writeString(value);
            });
            writer.writeObjectEnd();
        }
    }

}
