package ru.yandex.chemodan.util.idm;

import ru.yandex.bolts.collection.Option;

/**
 * @author yashunsky
 */
public class RoleDescription {
    public final String key;

    public final MultilingualString name;
    public final Option<MultilingualString> help;
    public final Option<Boolean> visibility;

    public RoleDescription(String key, MultilingualString name,
            Option<MultilingualString> help, Option<Boolean> visibility)
    {
        this.key = key;
        this.name = name;
        this.help = help;
        this.visibility = visibility;
    }

    public static RoleDescription simple(String key) {
        return explict(key, key);
    }

    public static RoleDescription explict(String key, String enName) {
        return new RoleDescription(key, MultilingualString.singleValue(enName), Option.empty(), Option.empty());
    }

    public static RoleDescription bilingual(String key, String enName, String ruName) {
        MultilingualString name = MultilingualString.bilingual(enName, ruName);
        return new RoleDescription(key, name, Option.empty(), Option.empty());
    }

}
