package ru.yandex.chemodan.util.idm;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.Validate;

/**
 * @author yashunsky
 */
@BenderBindAllFields
public class RoleNode {
    public final Option<Integer> code;

    public final Option<MultilingualString> name;

    public final Option<String> set;

    public final Option<MultilingualString> help;
    public final Option<Boolean> visibility;

    public final Option<SlugNode> roles;

    private RoleNode(Option<Integer> code,
            Option<MultilingualString> name,
            Option<String> set,
            Option<MultilingualString> help, Option<Boolean> visibility,
            Option<SlugNode> roles)
    {
        this.code = code;
        this.name = name;
        this.set = set;
        this.help = help;
        this.visibility = visibility;
        this.roles = roles;
    }

    public RoleNode hidden() {
        return new RoleNode(code, name, set, help, Option.of(false), roles);
    }

    public RoleNode withSet(String set) {
        return new RoleNode(code, name, Option.of(set), help, visibility, roles);
    }

    public static RoleNode root(SlugNode roles) {
        return new RoleNode(Option.of(0), Option.empty(), Option.empty(),
                Option.empty(), Option.empty(), Option.of(roles));
    }

    public static RoleNode intermediate(MultilingualString name, SlugNode roles) {
        return new RoleNode(Option.empty(), Option.of(name), Option.empty(),
                Option.empty(), Option.empty(), Option.of(roles));
    }

    public static RoleNode definitive(RoleDescription description) {
        return new RoleNode(Option.empty(), Option.of(description.name),
                Option.empty(), description.help, description.visibility, Option.empty());
    }

    public IdmInfoResponse asIdmInfo() {
        Validate.equals(Option.of(0), code);
        Validate.isTrue(roles.isPresent());

        return new IdmInfoResponse(roles.get());
    }
}
