package ru.yandex.chemodan.util.idm;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.Validate;

/**
 * @author yashunsky
 */
@Bendable
public class RoleSpecification extends DefaultObject {
    private final Tuple2List<String, String> spec;

    public RoleSpecification(Tuple2List<String, String> spec) {
        Validate.notEmpty(spec);
        this.spec = spec;
    }

    public ListF<String> getValues(ListF<String> keys) {
        if (spec.get1().unique().equals(keys.unique())) {
            MapF<String, String> specMap = spec.toMap();
            return keys.map(specMap::getTs);
        } else {
            return Cf.list();
        }
    }

    public void writeToJson(BenderJsonWriter writer) {
        writer.writeObjectStart();
        spec.forEach((field, value) -> {
            writer.writeFieldName(field);
            writer.writeString(value);
        });
        writer.writeObjectEnd();
    }
}
