package ru.yandex.chemodan.util.idm;

import javax.annotation.Nullable;

import ru.yandex.bolts.function.Function;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.IllegalParameterException;
import ru.yandex.commune.a3.action.parameter.convert.ConverterToType;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.lang.Validate;

/**
 * @author yashunsky
 */
public class RoleSpecificationConverter implements ConverterToType<RoleSpecification> {
    @Override
    public RoleSpecification convert(@Nullable String s, ActionInvocationContext invocationContext) {
        Validate.notNull(s);

        Function<JsonValue, String> extractRole = value -> {
            if (value instanceof JsonString) {
                return ((JsonString) value).getString();
            } else {
                throw new IllegalParameterException("Need string, received: " + value.toString());
            }
        };

        return new RoleSpecification(JsonObject.parseObject(s).getObject().map2(extractRole));
    }
}
