package ru.yandex.chemodan.util.idm;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
@BenderBindAllFields
public class SlugNode {
    public static final String ROLE_KEY = "role";

    public final String slug;
    public final MultilingualString name;
    public final MapF<String, RoleNode> values;

    public SlugNode(String slug, MultilingualString name, MapF<String, RoleNode> values) {
        this.slug = slug;
        this.name = name;
        this.values = values;
    }

    public static SlugNode definitiveDefault(ListF<RoleDescription> descriptions) {
        return definitiveDefault(descriptions, false);
    }

    public static SlugNode definitiveDefaultWithSet(ListF<RoleDescription> descriptions) {
        return definitiveDefault(descriptions, true);
    }

    public static SlugNode definitiveDefault(ListF<RoleDescription> descriptions, boolean withSet) {
        return definitive(ROLE_KEY, MultilingualString.bilingual("role", "роль"), descriptions, withSet);
    }

    public static SlugNode definitive(String slug, MultilingualString name, ListF<RoleDescription> descriptions) {
        return definitive(slug, name, descriptions, false);
    }

    public static SlugNode definitive(
            String slug, MultilingualString name, ListF<RoleDescription> descriptions, boolean withSet)
    {
        Function<RoleDescription, RoleNode> getRoleNodeF = description -> {
            RoleNode node = RoleNode.definitive(description);
            if (withSet) {
                return node.withSet(description.key);
            } else {
                return node;
            }
        };

        return new SlugNode(slug, name, descriptions.toMap(d -> d.key, getRoleNodeF));
    }
}
