package ru.yandex.chemodan.util.jdbc;

import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.misc.db.PooledDSFactorySupportConfigurator;
import ru.yandex.misc.db.hikari.HikariPooledDSFactorySupportConfigurator;
import ru.yandex.misc.db.pool.PooledDataSourceFactorySupport;

/**
 * @author vpronto
 */
public class CompositePooledDSFactorySupportConfigurator
        implements PooledDSFactorySupportConfigurator<DataSourceProperties>
{

    private final LocationResolver locationResolver;

    public CompositePooledDSFactorySupportConfigurator(LocationResolver locationResolver) {
        this.locationResolver = locationResolver;
    }

    @Override
    public PooledDataSourceFactorySupport configure(DataSourceProperties dataSourceProperties) {
        return new HikariPooledDSFactorySupportConfigurator(locationResolver).configure(dataSourceProperties);
    }
}
