package ru.yandex.chemodan.util.jdbc;

import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.core.env.Environment;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.alive2.location.ConductorYpQloudLocationResolver;
import ru.yandex.commune.alive2.location.Location;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.ConductorClientCached;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class ConductorDbListUtilsTest {

    private final Conductor conductor = new Conductor(File2.tmpDir().getAbsolutePath(), new ConductorClientCached());
    private final LocationResolver resolver = new ConductorYpQloudLocationResolver(conductor, Mockito.mock(Environment.class));

    @Test
    public void parseTesting() {
        Assert.equals(
                Cf.list(
                        new ConductorDbListUtils.HostInfo(
                                "pgtest01d.mail.yandex.net",
                                "d",
                                1
                        ),
                        new ConductorDbListUtils.HostInfo(
                                "pgtest01e.mail.yandex.net",
                                "e",
                                1
                        ),
                        new ConductorDbListUtils.HostInfo(
                                "pgtest01g.mail.yandex.net",
                                "g",
                                1
                        ),
                        new ConductorDbListUtils.HostInfo(
                                "pgtest04d.mail.yandex.net",
                                "d",
                                4
                        ),
                        new ConductorDbListUtils.HostInfo(
                                "pgtest04e.mail.yandex.net",
                                "e",
                                4
                        ),
                        new ConductorDbListUtils.HostInfo(
                                "pgtest04g.mail.yandex.net",
                                "g",
                                4
                        ),
                        new ConductorDbListUtils.HostInfo(
                                "apidb-test01d.cmail.yandex.net",
                                "d",
                                1
                        )
                ),
                Cf.list("pgtest01d.mail.yandex.net",
                        "pgtest01e.mail.yandex.net",
                        "pgtest01g.mail.yandex.net",
                        "pgtest04d.mail.yandex.net",
                        "pgtest04e.mail.yandex.net",
                        "pgtest04g.mail.yandex.net",
                        "apidb-test01d.cmail.yandex.net").map(ConductorDbListUtils.parseF()));
    }

    @Test
    public void parseProduction() {
        Assert.equals(
                Cf.list(
                        new ConductorDbListUtils.HostInfo(
                                "apidb01d.disk.yandex.net",
                                "d",
                                1
                        ),
                        new ConductorDbListUtils.HostInfo(
                                "apidb01e.disk.yandex.net",
                                "e",
                                1
                        ),
                        new ConductorDbListUtils.HostInfo(
                                "apidb01g.disk.yandex.net",
                                "g",
                                1
                        )
                ),
                Cf.list("apidb01d.disk.yandex.net",
                        "apidb01e.disk.yandex.net",
                        "apidb01g.disk.yandex.net").map(ConductorDbListUtils.parseF()));
    }

    @Test
    public void inSameDc() {
        Assert.isTrue(ConductorDbListUtils.inSameDc(Location.newLocation().dcName(Option.of("iva")).build(), "apidb01e.disk.yandex.net", resolver));
        Assert.isTrue(ConductorDbListUtils.inSameDc(Location.newLocation().dcName(Option.of("fol")).build(), "apidb01g.disk.yandex.net", resolver));

        Assert.isTrue(ConductorDbListUtils.inSameDc(Location.newLocation().dcName(Option.of("iva")).build(), "smartcache-worker01e.disk.yandex.net", resolver));
        Assert.isTrue(ConductorDbListUtils.inSameDc(Location.newLocation().dcName(Option.of("sas")).build(), "smartcache-worker01h.disk.yandex.net", resolver));

        Assert.isFalse(ConductorDbListUtils.inSameDc(Location.newLocation().dcName(Option.of("sas")).build(), "smartcache-worker01g.disk.yandex.net", resolver));
        Assert.isFalse(ConductorDbListUtils.inSameDc(Location.newLocation().dcName(Option.of("fol")).build(), "smartcache-worker01h.disk.yandex.net", resolver));

        Assert.isTrue(ConductorDbListUtils.inSameDc(Location.newLocation().dcName(Option.of("fol")).build(), "bbbbb01g.disk.yandex.net", resolver));
        Assert.isFalse(ConductorDbListUtils.inSameDc(Location.newLocation().dcName(Option.of("sas")).build(), "aaaaaa01g.disk.yandex.net", resolver));
    }
}
