package ru.yandex.chemodan.util.jdbc;

import java.sql.Connection;

import javax.sql.DataSource;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.util.jdbc.logging.LastAccessedDsAwareQueryInterceptor;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.misc.db.masterSlave.dynamic.DynamicMasterSlaveDataSource;
import ru.yandex.misc.db.masterSlave.dynamic.DynamicMasterSlaveDataSourceFactoryBeanSupport;
import ru.yandex.misc.io.IoFunction;

/**
 * @author tolmalev
 * @author fromen
 */
public class DcAwareDynamicMasterSlaveDataSourceFactory extends
        DynamicMasterSlaveDataSourceFactoryBeanSupport<DcAwareDynamicMasterSlaveDataSource>
{

    private final LocationResolver locationResolver;
    private final int replicationMaximumLag;
    private final long delayBetweenPingsMillis;

    private final LastAccessedDsAwareQueryInterceptor lastAccessedDsAwareQueryInterceptor;

    public DcAwareDynamicMasterSlaveDataSourceFactory(
            LocationResolver locationResolver, int replicationMaximumLag, long delayBetweenPingsMillis,
            LastAccessedDsAwareQueryInterceptor lastAccessedDsAwareQueryInterceptor)
    {
        this.locationResolver = locationResolver;
        this.replicationMaximumLag = replicationMaximumLag;
        this.delayBetweenPingsMillis = delayBetweenPingsMillis;
        this.lastAccessedDsAwareQueryInterceptor = lastAccessedDsAwareQueryInterceptor;
    }

    private boolean inSameDc(String hostname) {
        return ConductorDbListUtils.inSameDc(locationResolver.resolveLocation(), hostname, locationResolver);
    }

    @Override
    public ListF<String> sortHosts(ListF<String> urls) {
        return urls.sortedByDesc(this::inSameDc);
    }

    @Override
    protected DcAwareDynamicMasterSlaveDataSource createDynamicMasterSlaveDataSource(
            ListF<DataSource> datasources,
            DynamicMasterSlaveDataSource.Options options,
            IoFunction<Connection, Connection> connectionHandler)
    {
        return new DcAwareDynamicMasterSlaveDataSource(datasources, options, locationResolver,
                replicationMaximumLag, delayBetweenPingsMillis, lastAccessedDsAwareQueryInterceptor, connectionHandler);
    }

    @Override
    public Class<?> getObjectType() {
        return DcAwareDynamicMasterSlaveDataSource.class;
    }
}
