package ru.yandex.chemodan.util.jdbc;

import org.junit.Test;
import org.mockito.Matchers;
import org.springframework.core.env.Environment;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.util.jdbc.logging.LoggingQueryInterceptor;
import ru.yandex.chemodan.util.jdbc.logging.LoggingQueryInterceptorConfiguration;
import ru.yandex.commune.alive2.location.ConductorYpQloudLocationResolver;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.ConductorClientCached;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * @author tolmalev
 * @author fromen
 */
public class DcAwareDynamicMasterSlaveDataSourceFactoryTest {

    private final Conductor conductor = new Conductor(File2.tmpDir().getAbsolutePath(), new ConductorClientCached());
    private final Environment environment = mock(Environment.class);

    private final LoggingQueryInterceptorConfiguration loggingConf =
            new LoggingQueryInterceptorConfiguration("ru.yandex.chemodan.jdbc.q", () -> 500L);

    private int replicationMaximumLag = 30;
    private long delayBetweenPingsMillis = 1000;

    @Test
    public void sortHosts() {
        when(environment.getProperty(Matchers.eq("QLOUD_DATACENTER"))).thenReturn("iva");
        when(environment.getProperty(Matchers.eq("QLOUD_HOSTNAME"))).thenReturn("test01e.disk.yandex.net");
        LocationResolver resolver = new ConductorYpQloudLocationResolver(conductor, environment);
        DcAwareDynamicMasterSlaveDataSourceFactory factory =
                new DcAwareDynamicMasterSlaveDataSourceFactory(resolver, replicationMaximumLag, delayBetweenPingsMillis,
                        new LoggingQueryInterceptor(loggingConf));

        // by suffix
        Assert.equals("db01e.disk.yandex.net", factory.sortHosts(
                    Cf.list("db01g.disk.yandex.net", "db01d.disk.yandex.net", "db01e.disk.yandex.net")
                ).first()
        );

        Assert.equals("db01e.disk.yandex.net", factory.sortHosts(
                    Cf.list("db01g.disk.yandex.net", "db01e.disk.yandex.net", "db01d.disk.yandex.net")
                ).first()
        );

        Assert.equals("db01e.disk.yandex.net", factory.sortHosts(
                    Cf.list("db01e.disk.yandex.net", "db01g.disk.yandex.net", "db01d.disk.yandex.net")
                ).first()
        );

        when(environment.getProperty(Matchers.eq("QLOUD_HOSTNAME"))).thenReturn("sysdb01e.dst.yandex.net");

        // by conductor
        factory = new DcAwareDynamicMasterSlaveDataSourceFactory(resolver, replicationMaximumLag, delayBetweenPingsMillis,
                new LoggingQueryInterceptor(loggingConf));
        Assert.equals("sysdb01e.dst.yandex.net", factory.sortHosts(
                    Cf.list("sysdb01h.dst.yandex.net", "sysdb01g.dst.yandex.net", "sysdb01e.dst.yandex.net")
                ).first()
        );
    }
}
