package ru.yandex.chemodan.util.jdbc;

import javax.sql.DataSource;

import lombok.AllArgsConstructor;
import org.junit.Assert;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.alive2.location.Location;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.commune.alive2.location.LocationType;
import ru.yandex.misc.db.LocationExposedDataSource;
import ru.yandex.misc.db.hikari.HikariPooledDS;
import ru.yandex.misc.db.masterSlave.dynamic.DynamicDatasourceHolder;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class DcAwareDynamicMasterSlaveDataSourceTest {
    private final LocationResolver resolver = mock(LocationResolver.class);

    @Test
    public void getCheckers() {
        DcAwareDynamicMasterSlaveDataSource dataSource = new DcAwareDynamicMasterSlaveDataSource(Cf.list(),
                null, resolver, 0, 0, null, v -> v);

        when(resolver.resolveLocation())
                .thenReturn(new Location("someHost", Option.of("sas"), Option.empty(), Cf.list(),
                        LocationType.UNKNOWN));
        ListF<DynamicDatasourceHolder> checkers = Cf.list(
                makeDS("man"), makeDS("myt"), makeDS("iva")
        );
        checkers = dataSource.getCheckers(checkers);
        Location firstDSLocation = ((LocationExposedDataSource) checkers.first().getDataSource()).getLocation();
        Assert.assertNotEquals("man", firstDSLocation.dcName.get());
    }

    private static DynamicDatasourceHolderStub makeDS(String dcName) {
        HikariPooledDS mock = mock(HikariPooledDS.class);
        when(mock.getLocation()).thenReturn(new Location("someHost", Option.of(dcName), Option.empty(), Cf.list(),
                LocationType.UNKNOWN));
        return new DynamicDatasourceHolderStub(mock);
    }

    @AllArgsConstructor
    private static class DynamicDatasourceHolderStub implements DynamicDatasourceHolder {

        private HikariPooledDS dataSource;

        @Override
        public String getUrl() {
            return null;
        }

        @Override
        public boolean isMaster() {
            return false;
        }

        @Override
        public DataSource getDataSource() {
            return dataSource;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public boolean isSyncReplica() {
            return false;
        }
    }
}
