package ru.yandex.chemodan.util.jdbc;

import java.sql.Connection;

import javax.sql.DataSource;

import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.test.TestHelper;
import ru.yandex.misc.db.CloseableDataSource;
import ru.yandex.misc.db.ExposeConnectionCountDataSource;
import ru.yandex.misc.db.kind.ExposeDbKind;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class EqualByShardDcAwareDynamicMasterSlaveDataSourceTest {

    static {
        TestHelper.initialize();
    }

    @Test
    public void equal() {
        ListF<DataSource> sources = Cf.list(1, 1, 2).map(id -> new EqualByShardDcAwareDynamicMasterSlaveDataSource(
                id + "", Mockito.mock(DcAwareDynamicMasterSlaveDataSource.class)));

        Connection connection = Mockito.mock(Connection.class);

        TransactionSynchronizationManager.bindResource(sources.get(0), connection);
        Assert.equals(connection, TransactionSynchronizationManager.getResource(sources.get(1)));

        Assert.isFalse(TransactionSynchronizationManager.hasResource(sources.get(2)));

        TransactionSynchronizationManager.unbindResource(sources.get(1));
        Assert.isFalse(TransactionSynchronizationManager.hasResource(sources.get(0)));
    }

    @Test
    public void interfaces() {
        DataSource source = new EqualByShardDcAwareDynamicMasterSlaveDataSource(
                "id", Mockito.mock(DcAwareDynamicMasterSlaveDataSource.class));

        Assert.isInstance(source, CloseableDataSource.class);
        Assert.isInstance(source, ExposeConnectionCountDataSource.class);
        Assert.isInstance(source, ExposeDbKind.class);
    }
}
