package ru.yandex.chemodan.util.jdbc;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.util.jdbc.logging.LoggingQueryInterceptorConfiguration;
import ru.yandex.chemodan.util.jdbc.logging.LoggingQueryInterceptorConfigurationContextConfiguration;
import ru.yandex.chemodan.util.sharpei.ShardInfoSource;
import ru.yandex.chemodan.util.sharpei.SharpeiClient;
import ru.yandex.chemodan.util.sharpei.SharpeiShardInfoSource;
import ru.yandex.chemodan.util.sharpei.StaticShardInfoSource;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.commune.alive2.location.LocationResolverConfiguration;
import ru.yandex.inside.admin.conductor.ConductorContextConfiguration;

/**
 * @author tolmalev
 * TODO: rename it?
 */
@Configuration
@Import({
        ConductorContextConfiguration.class,
        LocationResolverConfiguration.class,
        LoggingQueryInterceptorConfigurationContextConfiguration.class,
})
public class JdbcDatabaseConfiguratorContextConfiguration {
    public final LoggingQueryInterceptorConfiguration loggingQueryInterceptorConfiguration;

    public final LocationResolver locationResolver;

    @Autowired
    public JdbcDatabaseConfiguratorContextConfiguration(
            LocationResolver locationResolver,
            LoggingQueryInterceptorConfiguration loggingQueryInterceptorConfiguration)
    {

        this.locationResolver = locationResolver;
        this.loggingQueryInterceptorConfiguration = loggingQueryInterceptorConfiguration;
    }

    public JdbcDatabaseConfigurator consJdbcConfigurator(DataSourceProperties dataSourceProperties) {
        return new JdbcDatabaseConfigurator.DynamicConfigurator(
                locationResolver, loggingQueryInterceptorConfiguration, dataSourceProperties,
                new StaticShardInfoSource(locationResolver, dataSourceProperties)
        );
    }

    public JdbcDatabaseConfigurator consDynamicJdbcConfigurator(
            DataSourceProperties dataSourceProperties,
            ShardInfoSource shardInfoSource)
    {
        return new JdbcDatabaseConfigurator.DynamicConfigurator(
                locationResolver,
                loggingQueryInterceptorConfiguration,
                dataSourceProperties,
                shardInfoSource);

    }

    public JdbcDatabaseConfigurator consSharpeiJdbcConfigurator(
            DataSourceProperties dataSourceProperties,
            SharpeiClient sharpeiClient)
    {
        return new JdbcDatabaseConfigurator.DynamicConfigurator(
                locationResolver,
                loggingQueryInterceptorConfiguration,
                dataSourceProperties,
                new SharpeiShardInfoSource(sharpeiClient));

    }
}
