package ru.yandex.chemodan.util.jdbc;

import javax.sql.DataSource;

import org.springframework.jdbc.core.PreparedStatementSetter;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;
import ru.yandex.misc.spring.jdbc.intercept.QueryInterceptor;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class JdbcTemplateParams extends DefaultObject {
    private final Function<DataSource, QueryInterceptor> interceptorF;

    private final Function<Object[], PreparedStatementSetter> preparedStatementSetterF;

    public JdbcTemplateParams(
            Function<DataSource, QueryInterceptor> interceptorF,
            Function<Object[], PreparedStatementSetter> preparedStatementSetterF)
    {
        this.interceptorF = interceptorF;
        this.preparedStatementSetterF = preparedStatementSetterF;
    }

    public JdbcTemplateParams withInterceptorF(Function<DataSource, QueryInterceptor> interceptorF) {
        return new JdbcTemplateParams(interceptorF, preparedStatementSetterF);
    }

    public JdbcTemplateParams withPreparedStatementSetterF(
            Function<Object[], PreparedStatementSetter> preparedStatementSetterF)
    {
        return new JdbcTemplateParams(interceptorF, preparedStatementSetterF);
    }

    public JdbcTemplate3 consTemplate(DataSource dataSource) {
        return new JdbcTemplate3(dataSource) {
            @Override
            protected QueryInterceptor createQueryInterceptor() {
                return interceptorF.apply(dataSource);
            }

            @Override
            protected PreparedStatementSetter newArgPreparedStatementSetter(Object[] args) {
                return preparedStatementSetterF.apply(args);
            }
        };
    }
}
