package ru.yandex.chemodan.util.jdbc;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author dbrylev
 */
@AllArgsConstructor
public class PgCredentials {

    private final static String READ_USER_SUFFIX = "_read";

    private final static Logger logger = LoggerFactory.getLogger(PgCredentials.class);

    @Getter
    private final User mainUser;
    @Getter
    private final Option<User> readOnlyUser;

    public static PgCredentials resolve(String username, String password, String pgpassFilePath, String dbName) {
        File2 pgPassFile = new File2(pgpassFilePath);

        Option<User> mainUserO = Option.empty();
        Option<User> readOnlyUserO = Option.empty();

        if (pgPassFile.exists()) {
            for (String line : pgPassFile.asReaderTool().readLines()) {
                String[] parts = line.split(":");
                if (StringUtils.equals(dbName, parts[2])) {
                    User user = new User(parts[3], parts[4]);
                    if (user.isRead()) {
                        readOnlyUserO = Option.of(user);
                    } else {
                        mainUserO = Option.of(user);
                    }
                }
            }
            if (!mainUserO.isPresent()) {
                logger.warn("Database {} credentials not found in file {}", dbName, pgpassFilePath);
            }
        }

        return new PgCredentials(mainUserO.getOrElse(new User(username, password)), readOnlyUserO);
    }

    @AllArgsConstructor
    @Getter
    public static class User extends DefaultObject {
        private final String username;
        private final String password;

        public User(Tuple2<String, String> usernameAndLogin) {
            this(usernameAndLogin._1, usernameAndLogin._2);
        }

        public boolean isRead() {
            return username.endsWith(READ_USER_SUFFIX);
        }
    }
}
