package ru.yandex.chemodan.util.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.jdbc.logging.LoggingQueryInterceptorConfiguration;
import ru.yandex.chemodan.util.test.EmbeddedDBDataSourceProperties;
import ru.yandex.commune.alive2.location.Location;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.misc.db.embedded.EmbeddedPostgres;
import ru.yandex.misc.db.embedded.EmbeddedPostgresConfiguration;
import ru.yandex.misc.db.embedded.PreparedDbProvider;
import ru.yandex.misc.db.masterSlave.MasterSlaveContextHolder;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.io.IoFunction0;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.test.Assert;

/**
 * @author yashunsky
 */
public class ReadWriteDataSourceFallbackTest {
    private static EmbeddedPostgres postgres;

    @BeforeClass
    public static void prepare() throws IOException {
        postgres = new EmbeddedPostgresConfiguration().pg();
    }

    @AfterClass
    public static void clean() throws IOException {
        postgres.close();
    }

    @Test
    public void testFallback() throws SQLException {
        PreparedDbProvider preparedDbProvider = PreparedDbProvider.forPreparer("test", postgres);
        EmbeddedDBDataSourceProperties properties =
                new EmbeddedDBDataSourceProperties(preparedDbProvider.createDatabase());

        properties.setPgpass("");
        properties.setMaxActive(1);
        properties.setReadMaxActive(1);
        properties.setMaxWaitMillis(1000);
        properties.setUrlPrefix("jdbc:postgresql://");
        properties.setUrlSuffix("");
        properties.setReadUsername("nonExistingUser");
        properties.setReadPassword("D0esn't_Matter");

        Location location = Location.newLocation().dcName(Option.of("someDC")).build();

        LocationResolver locationResolver = Mockito.mock(LocationResolver.class);
        Mockito.when(locationResolver.resolveHostsFromString(Mockito.any())).thenReturn(Cf.list("localhost"));
        Mockito.when(locationResolver.resolveLocation()).thenReturn(location);
        Mockito.when(locationResolver.resolveLocationFor(Mockito.any())).thenReturn(location);
        LoggingQueryInterceptorConfiguration loggingQueryConf =
                Mockito.mock(LoggingQueryInterceptorConfiguration.class);

        Validate.notBlank(properties.getReadUsername());
        JdbcDatabaseConfigurator configurator =
                new JdbcDatabaseConfigurator(locationResolver, loggingQueryConf, properties);
        DataSource dataSource = configurator.configureDataSource();

        String usedUsername = MasterSlaveContextHolder
                .withPolicy(MasterSlavePolicy.R_M, (IoFunction0<Connection>) dataSource::getConnection)
                .getMetaData().getUserName();

        Assert.notEquals(properties.getReadUsername(), usedUsername);
        Assert.equals(properties.getUsername(), usedUsername);
    }
}
