package ru.yandex.chemodan.util.jdbc.logging;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ThreadLocalX;
import ru.yandex.misc.db.url.JdbcUrl;

/**
 * @author dbrylev
 */
public class LastAccessedDsHolder {

    private final ThreadLocalX<Info> info = new ThreadLocalX<>();

    public Option<Info> get() {
        return info.getO();
    }

    public void set(JdbcUrl url, boolean isMaster) {
        info.set(new Info(url, isMaster));
    }

    public void remove() {
        info.remove();
    }

    public static class Info {
        public final JdbcUrl url;
        public final boolean isMaster;

        public Info(JdbcUrl url, boolean isMaster) {
            this.url = url;
            this.isMaster = isMaster;
        }
    }
}
