package ru.yandex.chemodan.util.jdbc.logging;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author dbrylev
 */
@Configuration
public class LoggingQueryInterceptorConfigurationContextConfiguration {
    @Value("${jdbc.long-query}")
    private Duration longQuery;
    @Value("${jdbc.queries-logger-name}")
    private String jdbcQueriesLoggerName;

    @Bean
    public LoggingQueryInterceptorConfiguration loggingQueryConfiguration() {
        return new LoggingQueryInterceptorConfiguration(jdbcQueriesLoggerName, longQuery::getMillis);
    }
}
