package ru.yandex.chemodan.util.json;

import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

import ru.yandex.misc.ExceptionUtils;

/**
 * @author Denis Bakharev
 */
public class JsonNodeUtils {

    private static final ObjectMapper mapper = new ObjectMapper()
            .disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);

    public static JsonNode getNode(byte[] content) {
        try {
            return mapper.readTree(content);
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public static JsonNode getNode(String jsonString) {
        try {
            return mapper.readTree(jsonString);
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public static JsonNode getNode(Map<?, ?> map) {
        try {
            return mapper.valueToTree(map);
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }
}
