package ru.yandex.chemodan.util.json;

import ru.yandex.commune.json.JsonNumber;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;

/**
 * @author dbrylev
 */
public class JsonObjectUtils {

    public static String getValueAsText(JsonValue value) {
        if (value instanceof JsonString) {
            return ((JsonString) value).getString();
        }
        if (value instanceof JsonNumber) {
            return ((JsonNumber) value).getValue().toString();
        }
        throw new IllegalArgumentException(
                "Unexpected json field value: " + value.getClass().getSimpleName() + " " + value.toString());
    }

    public static Long getValueAsLong(JsonValue value) {
        return Long.parseLong(getValueAsText(value));
    }
}
