package ru.yandex.chemodan.util.json;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.bolts.collection.Option;

/**
 * @author friendlyevil
 */
public class SimpleJsonPathNavigator implements JsonNodePathNavigator {
    private final String path;

    public SimpleJsonPathNavigator(String path) {
        this.path = path;
    }

    @Override
    public Option<JsonNode> getO(JsonNode node) {
        if (node.has(path)) {
            return Option.of(node.get(path));
        }

        return Option.empty();
    }
}
