package ru.yandex.chemodan.util.json;

import java.util.Iterator;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.bolts.collection.Option;

/**
 * @author friendlyevil
 */
public class SuffixJsonPathNavigator implements JsonNodePathNavigator{
    private final String suffix;

    public SuffixJsonPathNavigator(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public Option<JsonNode> getO(JsonNode node) {
        Iterator<String> fieldNameIter = node.fieldNames();
        while (fieldNameIter.hasNext()) {
            String next = fieldNameIter.next();
            if (next.endsWith(suffix)) {
                return Option.of(node.get(next));
            }
        }

        return Option.empty();
    }
}
