package ru.yandex.chemodan.util.mp3info;

import java.io.IOException;
import java.util.Arrays;

import org.apache.http.client.HttpClient;

import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.chemodan.util.DownloadFromMulcaGrabber;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class Mpr3ListDownloader {
    private static final Logger logger = LoggerFactory.getLogger(Mpr3ListDownloader.class);

    private static final String mulcagateUrl = "http://127.0.0.1:10010/gate";
    private static final String MULCA_SERVICE = "disk";
    private static final String MULCA_NAMESPACE = "disk";

    public static void main(String[] args) throws IOException {
        Log4jHelper.configureTestLogger();

        if (args.length < 1) {
            System.out.println("Enter input file name!");
            return;
        }

        HttpClient mulcaHttpClient = ApacheHttpClientUtils.singleConnectionClient(Timeout.seconds(10));
        MulcaClient mulcaClient = MulcaClient.custom(mulcaHttpClient, mulcagateUrl).withService(MULCA_SERVICE)
                .withNamespace(MULCA_NAMESPACE).build();

        for (String ext : Arrays.asList("m3u", "m3u8", "pls", "fpl")) {
            logger.debug("Start grabbing extension: " + ext);
            File2 dir = new File2("result/" + ext);
            dir.mkdirs();

            String params = "&text=ext:" + ext + "&get=name,stid&length=1";
            DownloadFromMulcaGrabber grabber = new DownloadFromMulcaGrabber(dir, 1000, params, mulcaClient);
            grabber.grabInfoForUids(args[0]);
        }
    }
}
