package ru.yandex.chemodan.util.oauth;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@BenderBindAllFields
public class OauthAccessToken extends DefaultObject {
    private static final BenderMapper mapper = new BenderMapper();

    @BenderPart(name = "token_type", strictName = true)
    public final String type;

    @BenderPart(name = "access_token", strictName = true)
    public final String token;

    @BenderPart(name = "expires_in", strictName = true)
    public final Option<Long> expiresIn;

    public final PassportUid uid;

    public OauthAccessToken(String type, String token, PassportUid uid) {
        this(type, token, Option.empty(), uid);
    }

    public OauthAccessToken(String type, String token, Option<Long> expiresIn, PassportUid uid) {
        this.type = type;
        this.token = token;
        this.expiresIn = expiresIn;
        this.uid = uid;
    }

    public static OauthAccessToken parseJson(String json) {
        return mapper.parseJson(OauthAccessToken.class, json);
    }
}
