package ru.yandex.chemodan.util.oauth;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class OauthAccessTokenTest {
    @Test
    public void parse() {
        OauthAccessToken token = new OauthAccessToken(
                "bearer",
                "AQAAAADundx5AAAKTf2AYF756Eienb8J0QdWrRw",
                Option.of(31536000L),
                new PassportUid(4003323001L)
        );

        String json = "{" +
                "\"token_type\": \"" + token.type + "\", " +
                "\"access_token\": \"" + token.token + "\", " +
                "\"expires_in\": " + token.expiresIn.get() + ", " +
                "\"uid\": " + token.uid +
                "}";
        Assert.equals(OauthAccessToken.parseJson(json), token);
    }
}
