package ru.yandex.chemodan.util.oauth;

import java.net.URI;

import ru.yandex.inside.passport.blackbox2.BlackboxType;
import ru.yandex.misc.io.http.UriBuilder;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum OauthEnvironment {
    TEST("http://oauth-test.yandex.ru/"),
    INTRANET("http://oauth.yandex-team.ru/"),
    PRODUCTION("http://oauth.yandex.ru/");

    public final URI url;

    OauthEnvironment(String url) {
        this.url = new UriBuilder(url).build();
    }

    public static OauthEnvironment byBlackboxType(BlackboxType blackboxType) {
        switch (blackboxType) {
            case TEST:
                return TEST;

            case INTRANET:
            case INTRANET_IPV6:
                return INTRANET;

            case PRODUCTION:
            case MIMINO:
                return PRODUCTION;

            default:
                throw new IllegalArgumentException("Unknown blackbox type = " + blackboxType + ". " +
                                "Add corresponding type to " + OauthEnvironment.class);
        }
    }
}
