package ru.yandex.chemodan.util.oauth;

import java.io.IOException;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.misc.io.IoUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class OauthResponseParser {
    private static final Logger logger = LoggerFactory.getLogger(OauthResponseParser.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    private static final String ERROR_STATUS = "error";
    private static final String OK_STATUS = "ok";

    public String parseAuthorizationCodeResponse(String response) {
        try {
            JsonNode node = mapper.readTree(response);
            String status = node.get("status").textValue();
            switch (status) {
                case OK_STATUS:
                    return node.get("code").textValue();
                case ERROR_STATUS:
                    String errorMessage = StringUtils.join(node.get("errors").iterator(), ", ");
                    throw new RuntimeException("Couldn't get auth code: " + errorMessage);
                default:
                    throw new RuntimeException("Unknown status: " + status);
            }
        } catch (IOException e) {
            logger.warn("Couldn't parse response", e);
            throw IoUtils.translate(e);
        }
    }

}
