package ru.yandex.chemodan.util.oauth;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class OauthResponseParserTest {

    @Test
    public void parseAuthorizationCodeOkResponse() throws Exception {
        String response = "{\"status\": \"ok\", \"code\": \"qw7bd2nllodm24tk\", \"expires_in\": 600}";
        OauthResponseParser parser = new OauthResponseParser();

        String code = parser.parseAuthorizationCodeResponse(response);
        Assert.assertContains("qw7bd2nllodm24tk", code);
    }

    @Test
    public void parseAuthorizationCodeErrResponse() throws Exception {
        String response = "{\"status\": \"error\", \"errors\": [\"code_strength.invalid\", \"client_id.too_short\"]}";
        OauthResponseParser parser = new OauthResponseParser();

        try {
            parser.parseAuthorizationCodeResponse(response);
            Assert.fail("Exception expected");
        } catch (RuntimeException e) {
            Assert.assertContains(e.getMessage(), "\"code_strength.invalid\", \"client_id.too_short\"");
        }
    }

}
