package ru.yandex.chemodan.util.passport;

import ru.yandex.chemodan.util.oauth.OauthEnvironment;
import ru.yandex.inside.passport.blackbox2.BlackboxType;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class AbstractPassportEntity extends DefaultObject {
    public final BlackboxType blackboxType;

    protected AbstractPassportEntity(BlackboxType blackboxType) {
        this.blackboxType = blackboxType;
    }

    public OauthEnvironment getOauthEnvironment() {
        return OauthEnvironment.byBlackboxType(blackboxType);
    }
}
