package ru.yandex.chemodan.util.passport;

import ru.yandex.inside.passport.blackbox2.BlackboxType;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class PassportApp extends AbstractPassportEntity {
    public final String name;
    public final String id;
    public final String secret;

    private PassportApp(BlackboxType blackboxType, String name, String id, String secret) {
        super(blackboxType);
        this.name = name;
        this.id = id;
        this.secret = secret;
    }

    public static PassportApp atTesting(String name, String id, String secret) {
        return new PassportApp(BlackboxType.TEST, name, id, secret);
    }

    public static PassportApp atProduction(String name, String id, String secret) {
        return new PassportApp(BlackboxType.PRODUCTION, name, id, secret);
    }
}
