package ru.yandex.chemodan.util.passport;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.oauth.OauthAccessToken;
import ru.yandex.chemodan.util.oauth.OauthClient;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.BlackboxType;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class PassportUser extends AbstractPassportEntity {
    public final PassportUid uid;
    public final String username;
    public final String password;
    public final MapF<String, OauthAccessToken> tokens;

    private PassportUser(BlackboxType blackboxType, PassportUid uid, String username, String password) {
        this(blackboxType,  uid, username, password, Cf.map());
    }

    private PassportUser(BlackboxType blackboxType, PassportUid uid, String username, String password,
            MapF<String, OauthAccessToken> tokens)
    {
        super(blackboxType);
        this.uid = uid;
        this.username = username;
        this.password = password;
        this.tokens = tokens;
    }

    public static PassportUser atTesting(long uid, String username, String password) {
        return new PassportUser(BlackboxType.TEST, PassportUid.cons(uid), username, password);
    }

    public static PassportUser atProduction(long uid, String username, String password) {
        return new PassportUser(BlackboxType.PRODUCTION, PassportUid.cons(uid), username, password);
    }

    public PassportUser withToken(String appName, String type, String token) {
        return new PassportUser(blackboxType, uid, username, password,
                tokens.plus1(appName, new OauthAccessToken(type, token, uid))
        );
    }

    public OauthAccessToken getTokenFor(PassportApp app) {
        return getHardcodedTokenO(app)
                .getOrElse(() -> getTokenFromPassportFor(app));
    }

    private Option<OauthAccessToken> getHardcodedTokenO(PassportApp app) {
        return tokens.getO(app.name);
    }

    private OauthAccessToken getTokenFromPassportFor(PassportApp app) {
        return new OauthClient(app)
                .getAccessTokenByPassword(username, password);
    }
}
