package ru.yandex.chemodan.util.photoinfo;

import ru.yandex.chemodan.util.search.SearchResult;
import ru.yandex.chemodan.util.search.SearchResult.SearchItem;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4;

/**
 * @author akirakozov
 */
public class MulcaExifExtractor {
    private static String HOST_AND_PORT = "storage.mail.yandex.net:10010";

    private final ApacheHttpClient4 httpClient = ApacheHttpClient4.newInstance(Timeout.seconds(5), 1);

    public SearchItem extractExifInfo(String mulcaId) {
        return SearchResult.parseSearchMulcaResult(httpClient.get(getExtractExifUrl(mulcaId)));
    }

    private String getExtractExifUrl(String mulcaId) {
        return "http://" + HOST_AND_PORT + "/gate/custom-get/" + mulcaId + "?name=disk&port=8081&method=get/" + mulcaId;
    }

}
