package ru.yandex.chemodan.util.photoinfo;

import java.io.IOException;
import java.io.Writer;

import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.chemodan.util.photoinfo.formatter.CryptaPhotoInfoFormatter;
import ru.yandex.chemodan.util.search.AbstractInfoFormatter;
import ru.yandex.chemodan.util.search.AbstractSearchInfoGrabber;
import ru.yandex.chemodan.util.search.SearchResult;
import ru.yandex.chemodan.util.search.SearchResult.SearchItem;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class PhotoInfoGrabber extends AbstractSearchInfoGrabber {
    private static final Logger logger = LoggerFactory.getLogger(PhotoInfoGrabber.class);

    private static final MulcaExifExtractor mulcaExifExtractor = new MulcaExifExtractor();
    private static final AbstractInfoFormatter formatter = new CryptaPhotoInfoFormatter();
    private static final UidToMd5Login uidToMd5Login = new UidToMd5Login("blackbox.yandex.net");

    public PhotoInfoGrabber(String outputFile) {
        super(outputFile);
    }

    public static void main(String[] args) throws IOException {
        Log4jHelper.configureTestLogger();

        if (args.length < 1) {
            System.out.println("Enter input file name!");
            return;
        }

        PhotoInfoGrabber grabber = new PhotoInfoGrabber("photo-info.log");
        grabber.grabInfoForUids(args[0]);
    }

    @Override
    protected void grabInfoForUid(PassportUid uid, Writer out) throws IOException {
        SearchResult result = searchClient.getPhotoInfoByUser(uid);

        out.write(uidToMd5Login.getMd5LoginFromUid(uid) + "\n");
        for (SearchItem item : result.items) {
            if (item.tikaiteError.isSome("invalid json")) {
                item = tryExtractExifFromMulca(uid, item);
            }
            out.write(formatter.format(uid, item) + "\n");
        }
    }

    private static SearchItem tryExtractExifFromMulca(PassportUid uid, SearchItem item) {
        try {
            Validate.some(item.stid, "No stid for uid =" + uid + ", path=" + item.path.get());

            SearchItem newItem = mulcaExifExtractor.extractExifInfo(item.stid.get());
            item.latitude = newItem.latitude;
            item.longitude = newItem.longitude;
            item.manufacturer = newItem.manufacturer;
            item.model = newItem.model;
            item.creationTimeInSec = newItem.creationTimeInSec;
        } catch (Exception e) {
            logger.warn(e, e);
        }
        return item;
    }
}
