package ru.yandex.chemodan.util.photoinfo;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.digest.Md5;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4;
import ru.yandex.misc.io.http.client.HttpClient;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @author akirakozov
 */
public class UidToMd5Login {
    private final String blackboxHost;
    private final HttpClient client = ApacheHttpClient4.newInstance(Timeout.seconds(5), 1);

    public UidToMd5Login(String blackboxHost) {
        this.blackboxHost = blackboxHost;
    }

    private String getBlackboxUrl(PassportUid uid) {
        return UrlUtils.addParameter("http://" + blackboxHost + "/blackbox?method=userinfo&userip=127.0.0.1",
                "uid", uid.getUid());
    }
    public String getMd5LoginFromUid(PassportUid uid) {
        String login = Dom4jUtils.readRootElement(client.get(getBlackboxUrl(uid))).element("login").getText();
        return Md5.A.digest(login.getBytes()).hex();
    }
}
