package ru.yandex.chemodan.util.photoinfo.formatter;

import ru.yandex.chemodan.util.search.AbstractInfoFormatter;
import ru.yandex.chemodan.util.search.SearchResult.SearchItem;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;

public class CryptaPhotoInfoFormatter extends AbstractInfoFormatter {

    @Override
    public String format(PassportUid uid, SearchItem item) {
    String creationDate = EMPTY_FIELD;
        String creationTime = EMPTY_FIELD;
        if (item.creationTimeInSec.isPresent()) {
            Long creationMs = item.creationTimeInSec.get() * 1000;
            creationDate = DATE_FORMATTER.print(creationMs);
            creationTime = TIME_FORMATTER.print(creationMs);
        }

        String geoCoords = EMPTY_FIELD;
        if (item.latitude.isPresent() && item.longitude.isPresent()) {
            geoCoords = item.latitude.get() + " " + item.longitude.get();
        }

        return StringUtils.format(
                "mdate={}\tcdate={}\tctime={}\tmake={}\tmodel={}\tgeo={}",
                DATE_FORMATTER.print(item.mtimeInSec.get() * 1000),
                creationDate,
                creationTime,
                item.manufacturer.getOrElse(EMPTY_FIELD),
                item.model.getOrElse(EMPTY_FIELD),
                geoCoords);
    }

}
