package ru.yandex.chemodan.util.photoinfo.formatter;

import ru.yandex.chemodan.util.search.AbstractInfoFormatter;
import ru.yandex.chemodan.util.search.SearchResult.SearchItem;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class PhotoInfoFormatter extends AbstractInfoFormatter {

    @Override
    public String format(PassportUid uid, SearchItem item) {
        String creationDate = EMPTY_FIELD;
        String creationTime = EMPTY_FIELD;
        if (item.creationTimeInSec.isPresent()) {
            Long creationMs = item.creationTimeInSec.get() * 1000;
            creationDate = DATE_FORMATTER.print(creationMs);
            creationTime = TIME_FORMATTER.print(creationMs);
        }

        String geoCoords = EMPTY_FIELD;
        if (item.latitude.isPresent() && item.longitude.isPresent()) {
            geoCoords = item.latitude.get() + " " + item.longitude.get();
        }

        String size = EMPTY_FIELD;
        if (item.width.isPresent() && item.height.isPresent()) {
            size = item.width.get() + "x" + item.height.get();
        }
        return StringUtils.format(
                "{}\t{}\t{}\t{}\t{}\t{}\t{}\t{}\t{}",
                uid,
                item.path.getOrElse(EMPTY_FIELD),
                DATE_FORMATTER.print(item.mtimeInSec.get() * 1000),
                creationDate,
                creationTime,
                item.manufacturer.getOrElse(EMPTY_FIELD),
                item.model.getOrElse(EMPTY_FIELD),
                geoCoords,
                size);
    }
}
