package ru.yandex.chemodan.util.postgres;

import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.UncategorizedSQLException;

/**
 * @author dbrylev
 */
public class PgErrorUtils {

    public static boolean isDuplicateErrorForKey(Exception e, String keyName) {
        return e instanceof DataIntegrityViolationException
                && e.getMessage().contains("ERROR: duplicate key value violates unique constraint \"" + keyName + "\"");
    }

    public static boolean isLockObtainError(Exception e) {
        return e instanceof UncategorizedSQLException
                && e.getMessage().contains("ERROR: could not obtain lock on row in relation");
    }
}
