package ru.yandex.chemodan.util.postgres;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.misc.db.q.ConditionUtils;
import ru.yandex.misc.db.q.SqlExpression;
import ru.yandex.misc.db.q.SqlQuery;
import ru.yandex.misc.db.q.SqlQueryUtils;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author dbrylev
 */
public class PgSqlQueryUtils {
    public static SqlQuery insertIgnoreQuery(String tableName, Tuple2List<String, Object> columnValues) {
        return new SqlQuery(insertIgnoreQueryString(tableName, columnValues.get1()), columnValues.get2());
    }

    public static String insertIgnoreQueryString(String tableName, ListF<String> columnNames) {
        return SqlQueryUtils.insertQueryString(tableName, columnNames) + " ON CONFLICT DO NOTHING";
    }

    private static final Pattern zeroPattern = Pattern.compile("(?<!\\\\)(?:\\\\\\\\)*\\\\u0000");

    public static String escapeJson(String json) {
        return zeroPattern.matcher(json).replaceAll("\\\\$0");
    }

    public static String escapeForLike(String value) {
        return StringUtils.replaceEach(value, new String[] {"\\", "%", "_"}, new String[] {"\\\\", "\\%", "\\_"});
    }

    public static String unescapeForLike(String value) {
        return StringUtils.replaceEach(value, new String[] {"\\\\", "\\%", "\\_"}, new String[] {"\\", "%", "_"});
    }

    private static final Pattern unescapedCodePattern = Pattern.compile("(?<!\\\\)(?:\\\\\\\\)*[%_]");

    public static Pattern2 likePattern(String sqlLike) {
        StringBuilder pattern = new StringBuilder();

        Function1V<String> appendText = text -> {
            if (!text.isEmpty()) {
                pattern.append(Pattern.quote(unescapeForLike(text)));
            }
        };

        Matcher matcher = unescapedCodePattern.matcher(sqlLike);
        int pos = 0;

        for (; matcher.find(pos); pos = matcher.end()) {
            appendText.apply(sqlLike.substring(pos, matcher.end() - 1));
            pattern.append(sqlLike.charAt(matcher.end() - 1) == '%' ? ".*" : ".");
        }
        appendText.apply(sqlLike.substring(pos));

        return Pattern2.compile("^" + pattern.toString() + "$");
    }

    public static <T> SqlExpression between(T min, T max) {
        return between(ConditionUtils.value(min), ConditionUtils.value(max));
    }

    public static SqlExpression between(SqlExpression min, SqlExpression max) {
        return new SqlExpression() {
            @Override
            public ListF<Object> args() {
                return min.args().plus(max.args());
            }

            @Override
            public String sql(Option<String> tableName) {
                return min.sql(tableName) + " AND " + max.sql(tableName);
            }
        };
    }
}
