package ru.yandex.chemodan.util.postgres;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

import static ru.yandex.chemodan.util.postgres.PgSqlQueryUtils.escapeForLike;
import static ru.yandex.chemodan.util.postgres.PgSqlQueryUtils.escapeJson;
import static ru.yandex.chemodan.util.postgres.PgSqlQueryUtils.likePattern;
import static ru.yandex.chemodan.util.postgres.PgSqlQueryUtils.unescapeForLike;

/**
 * @author dbrylev
 */
public class PgSqlQueryUtilsTest {

    @Test
    public void jsonEscape() {
        Assert.equals("u0000", escapeJson("u0000"));
        Assert.equals("\\\\u0000", escapeJson("\\u0000"));
        Assert.equals("\\\\u0000", escapeJson("\\\\u0000"));
        Assert.equals("\\\\\\\\u0000", escapeJson("\\\\\\u0000"));
        Assert.equals("\\\\\\\\u0000", escapeJson("\\\\\\\\u0000"));
        Assert.equals("\\\\u0000\\\\u0000", escapeJson("\\u0000\\u0000"));
    }

    @Test
    public void forLikeEscape() {
        Assert.equals("\\\\\\%\\\\\\%", escapeForLike("\\%\\%"));
        Assert.equals("\\_\\\\\\_\\%", escapeForLike("_\\_%"));
        Assert.equals("\\\\\\\\\\%", escapeForLike("\\\\%"));
        Assert.equals("\\%\\\\", escapeForLike("%\\"));
    }

    @Test
    public void forLikeUnescape() {
        Assert.equals("\\%\\%", unescapeForLike("\\\\\\%\\\\\\%"));
        Assert.equals("\\\\%", unescapeForLike("\\\\\\\\\\%"));
        Assert.equals("\\__", unescapeForLike("\\\\_\\_"));
        Assert.equals("%\\", unescapeForLike("\\%\\\\"));
    }

    @Test
    public void patternLike() {
        Assert.isTrue(likePattern("%").matches("abc"));
        Assert.isTrue(likePattern("%%%").matches("abc"));

        Assert.isTrue(likePattern("%" + escapeForLike("%")).matches("abc%"));
        Assert.isTrue(likePattern(escapeForLike("%") + "%").matches("%abc"));

        Assert.isFalse(likePattern("%" + escapeForLike("%")).matches("abc"));

        Assert.isTrue(likePattern("%" + escapeForLike("[]\\%")).matches("abc[]\\%"));
        Assert.isFalse(likePattern("%" + escapeForLike("[]\\%")).matches("abc[]\\%d"));

        Assert.isTrue(likePattern("_").matches("a"));
        Assert.isTrue(likePattern("__").matches("ab"));
        Assert.isFalse(likePattern("_").matches("ab"));

        Assert.isTrue(likePattern("_" + escapeForLike("_")).matches("a_"));
        Assert.isFalse(likePattern("_" + escapeForLike("_")).matches("_a"));

        Assert.isFalse(likePattern("%_").matches(""));
        Assert.isTrue(likePattern("%_").matches("abc"));
    }
}
