package ru.yandex.chemodan.util.retry;

import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.event.ContextualResultListener;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public class LoggingFailedAttemptListener<R, F extends Throwable> implements ContextualResultListener<R, F> {
    private static final Logger logger = LoggerFactory.getLogger(LoggingFailedAttemptListener.class);

    private String message = "";
    private int maxRetries = -1;

    public LoggingFailedAttemptListener(int maxRetries, String message) {
        this.maxRetries = maxRetries;
        this.message = StringUtils.removeEnd(message.trim(), ".") + ". ";
    }

    public LoggingFailedAttemptListener() {
    }

    @Override
    public void onResult(R result, F failure, ExecutionContext context) {
        logger.info(message
                + "Attempt number " + context.getExecutions() + " failed"
                + getProperEnding(context.getExecutions()) + ".", failure);
    }

    private String getProperEnding(int attemptNumber) {
        return (maxRetries < 0 || maxRetries > attemptNumber - 1) ? ", retrying" : ", skipping";
    }
}
