package ru.yandex.chemodan.util.retry;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.commune.a3.action.parameter.IllegalParameterException;
import ru.yandex.misc.log.mlf.ndc.Ndc;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class RetryProxyTest {

    @Test
    public void simple() {
        ListF<Integer> attempts = Cf.arrayList();

        Runnable runner = () -> {
            throw new IllegalParameterException("X");
        };

        Runnable proxy = RetryProxy.proxy(runner, Runnable.class, 3, Function1B.trueF(),
                new RetryProxy.Interceptor() {
                    public Object before(RetryProxy.Invocation invocation) {
                        attempts.add(invocation.attempt);
                        return null;
                    }
                });

        Assert.assertThrows(proxy::run, IllegalParameterException.class);

        Assert.equals(Cf.list(0, 1, 2, 3, 4), attempts);
    }

    @Test
    public void pushToNdc() {
        ListF<String> ndc = Cf.arrayList();

        Runnable runner = () -> {
            ndc.add(Ndc.get());

            throw new IllegalParameterException("X");
        };

        Runnable proxy = RetryProxy.proxy(
                runner, Runnable.class, 1, Function1B.trueF(), RetryProxy.pushToNdcInterceptor());

        Assert.assertThrows(proxy::run, IllegalParameterException.class);

        Assert.isNull(Ndc.get());

        Assert.equals(Cf.list(
                "#method=run,#attempt=1", "#method=run,#attempt=2"), ndc);

        ndc.clear();

        proxy = RetryProxy.proxy(proxy, Runnable.class, 0, Function1B.trueF(), RetryProxy.pushToNdcInterceptor());

        Assert.assertThrows(proxy::run, IllegalParameterException.class);

        Assert.equals(Cf.list(
                "#method=run,#attempt=1,#method=run,#attempt=1",
                "#method=run,#attempt=1,#method=run,#attempt=2"), ndc);
    }
}
