package ru.yandex.chemodan.util.search;

import java.io.IOException;
import java.io.Writer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public abstract class AbstractSearchInfoGrabber {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSearchInfoGrabber.class);

    private final File2 resultLog;
    protected final SearchClient searchClient = new SearchClient("search1j.disk.yandex.net:17001");

    public AbstractSearchInfoGrabber(String outputFile) {
        resultLog = new File2(outputFile);
    }

    public void grabInfoForUids(String uidsFile) throws IOException {
        File2 input = new File2(uidsFile);
        ListF<PassportUid> uids = input.readLines().map(Cf.Long.parseF().andThen(PassportUid.consF()));

        try (Writer out = resultLog.asWriterSource().getOutput()) {
            int processed = 0;
            for (PassportUid uid : uids) {
                try {
                    logger.debug("Start processing: " + uid);
                    grabInfoForUid(uid, out);
                } catch (Exception e) {
                    logger.warn("Couldn't get meta for uid: " + uid, e);
                }
                processed++;
                if (processed % 100 == 0) {
                    logger.debug("Processed " + processed + " users");
                }
                if (stopProcessing()) {
                    logger.debug("Stop processing by condition");
                    break;
                }
            }
        }
    }

    protected boolean stopProcessing() {
        return false;
    }

    protected abstract void grabInfoForUid(PassportUid uid, Writer out) throws IOException;
}
