package ru.yandex.chemodan.util.search;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.InputStreamSourceUtils2;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4;

/**
 * @author akirakozov
 */
public class SearchClient {
    private static String BASE_SEARCH_PATH = "/unicast/search?service=disk";
    private static String PHOTO_INFO_PARAMS = "&text=mimetype:image/*&"
            + "get=timestamp,mtime,model,manufacturer,latitude,longitude,height,width,key,created,stid,tikaite_error";
    private static String BOOK_INFO_PARAMS = "&text=ext:epub+OR+ext:fb2&get=title,author,name,ext,md5&length=500";
    private static String DJVU_INFO_PARAMS = "&text=ext:djvu&get=name,stid&length=1";
    private static String DOCUMENT_INFO_PARAMS = "&text=mediatype:6&hr&get=key,size,ctime,mtime";
    private static String VIDEO_INFO_PARAMS = "&text=mediatype:12&hr&get=key,size,mtime,created,width,height,ratio";

    private final String host;

    private final ApacheHttpClient4 httpClient = ApacheHttpClient4.newInstance(Timeout.seconds(10), 1);

    public SearchClient(String host) {
        this.host = host;
    }

    public SearchResult getPhotoInfoByUser(PassportUid uid) {
        return getSearchInfo(uid, PHOTO_INFO_PARAMS);
    }

    public SearchResult getDocumentInfoByUser(PassportUid uid) {
        return getSearchInfo(uid, DOCUMENT_INFO_PARAMS);
    }

    public SearchResult getVideoInfoByUser(PassportUid uid) {
        return getSearchInfo(uid, VIDEO_INFO_PARAMS);
    }

    public ListF<SearchResult.SearchItem> getUserBooksInfo(PassportUid uid) {
        return SearchResult.parseBookInfoList(
                InputStreamSourceUtils2.bytes(httpClient.get(getSearchUrl(BOOK_INFO_PARAMS, uid))));
    }

    public Option<SearchResult.SearchItem> getFirstDjvuInfo(PassportUid uid) {
        return SearchResult.parseFirstDjvuInfo(
                InputStreamSourceUtils2.bytes(httpClient.get(getSearchUrl(DJVU_INFO_PARAMS, uid))));
    }

    public SearchResult getSearchInfo(PassportUid uid, String searchParams) {
        return SearchResult.parseSearchResult(httpClient.get(getSearchUrl(searchParams, uid)));
    }

    private String getSearchUrl(String params, PassportUid uid) {
        String baseUrl = "http://" + host + BASE_SEARCH_PATH + params;
        return UrlUtils.addParameter(baseUrl, "prefix", uid.getUid());
    }
}
