package ru.yandex.chemodan.util.search;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.parse.BenderParserUtils;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.InputStreamSource;

/**
 * @author akirakozov
 */
@Bendable
public class SearchResult {
    private static BenderParser<SearchResult> searchResultParser =
            Bender.cons(SearchResult.class).getParser();
    private static BenderParser<SearchItem> searchItemParser =
            Bender.cons(SearchItem.class).getParser();

    @BenderBindAllFields
    public static class SearchItem {
        @BenderPart(name = "mtime")
        public Option<Long> mtimeInSec;
        @BenderPart(name = "ctime")
        public Option<Long> ctimeInSec;
        public Option<String> model;
        public Option<String> manufacturer;
        public Option<Double> latitude;
        public Option<Double> longitude;
        public Option<Integer> height;
        public Option<Integer> width;
        @BenderPart(name = "key")
        public Option<String> path;
        @BenderPart(name = "created")
        public Option<Long> creationTimeInSec;
        @BenderPart(name = "tikaite_error", strictName=true)
        public Option<String> tikaiteError;
        public Option<String> stid;
        public Option<String> title;
        public Option<String> author;
        @BenderPart(name = "name")
        public Option<String> filename;
        @BenderPart(name = "ext")
        public Option<String> extension;
        public Option<String> md5;
        public Option<Long> size;
        public Option<String> ratio;
    }

    @BenderPart(name = "hitsArray")
    public ListF<SearchItem> items;

    public static SearchResult parseSearchResult(String json) {
        return searchResultParser.parseJson(json);
    }

    public static SearchResult parseSearchResult(byte[] json) {
        return searchResultParser.parseJson(json);
    }

    public static SearchItem parseSearchMulcaResult(String json) {
        return searchItemParser.parseJson(json);
    }

    public static SearchItem parseSearchMulcaResult(byte[] json) {
        return searchItemParser.parseJson(json);
    }

    public static ListF<SearchItem> parseBookInfoList(InputStreamSource input) {
        if (input.lengthO().get() > DataSize.fromMegaBytes(50).toBytes()) {
            return Cf.list();
        }
        BenderJsonNode root = BenderParserUtils.json(input);
        BenderJsonNode infos = root.getField("hitsArray").get();
        return infos.getArrayElements()
                .map(node -> searchItemParser.parseJson(node))
                .filter(bookInfo ->  bookInfo.author.isPresent() && bookInfo.author.get().length() < 100)
                .filter(bookInfo -> bookInfo.author.isPresent() && bookInfo.title.get().length() < 200);
    }

    public static Option<SearchItem> parseFirstDjvuInfo(InputStreamSource input) {
        if (input.lengthO().get() > DataSize.fromMegaBytes(50).toBytes()) {
            return Option.empty();
        }
        BenderJsonNode root = BenderParserUtils.json(input);
        BenderJsonNode result = root.getField("hitsArray").get();
        return result.getArrayElements()
                .map(node -> searchItemParser.parseJson(node))
                .filter(sr -> sr.filename.isPresent() && sr.filename.get().length() < 100)
                .filter(sr -> sr.stid.isPresent())
                .firstO();
    }
}
